package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildSourceFluentImplAssert<S extends AbstractBuildSourceFluentImplAssert<S, A>, A extends BuildSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildSourceFluentImplAssert}</code> to make assertions on actual BuildSourceFluentImpl.
   * @param actual the BuildSourceFluentImpl we want to make assertions on.
   */
  protected AbstractBuildSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluentImpl's contextDir is equal to the given one.
   * @param contextDir the given contextDir to compare the actual BuildSourceFluentImpl's contextDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluentImpl's contextDir is not equal to the given one.
   */
  public S hasContextDir(String contextDir) {
    // check that actual BuildSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected contextDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContextDir = actual.getContextDir();
    if (!Objects.areEqual(actualContextDir, contextDir)) {
      failWithMessage(assertjErrorMessage, actual, contextDir, actualContextDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluentImpl's git is equal to the given one.
   * @param git the given git to compare the actual BuildSourceFluentImpl's git to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluentImpl's git is not equal to the given one.
   */
  public S hasGit(GitBuildSource git) {
    // check that actual BuildSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected git of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitBuildSource actualGit = actual.getGit();
    if (!Objects.areEqual(actualGit, git)) {
      failWithMessage(assertjErrorMessage, actual, git, actualGit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluentImpl's sourceSecret is equal to the given one.
   * @param sourceSecret the given sourceSecret to compare the actual BuildSourceFluentImpl's sourceSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluentImpl's sourceSecret is not equal to the given one.
   */
  public S hasSourceSecret(io.fabric8.kubernetes.api.model.LocalObjectReference sourceSecret) {
    // check that actual BuildSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected sourceSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualSourceSecret = actual.getSourceSecret();
    if (!Objects.areEqual(actualSourceSecret, sourceSecret)) {
      failWithMessage(assertjErrorMessage, actual, sourceSecret, actualSourceSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluentImpl's type is equal to the given one.
   * @param type the given type to compare the actual BuildSourceFluentImpl's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluentImpl's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual BuildSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
