package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeAddressFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeAddressFluentAssert<S extends AbstractNodeAddressFluentAssert<S, A>, A extends NodeAddressFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeAddressFluentAssert}</code> to make assertions on actual NodeAddressFluent.
   * @param actual the NodeAddressFluent we want to make assertions on.
   */
  protected AbstractNodeAddressFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeAddressFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeAddressFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeAddressFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeAddressFluent's address is equal to the given one.
   * @param address the given address to compare the actual NodeAddressFluent's address to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeAddressFluent's address is not equal to the given one.
   */
  public S hasAddress(String address) {
    // check that actual NodeAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected address of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualAddress = actual.getAddress();
    if (!Objects.areEqual(actualAddress, address)) {
      failWithMessage(assertjErrorMessage, actual, address, actualAddress);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeAddressFluent's type is equal to the given one.
   * @param type the given type to compare the actual NodeAddressFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeAddressFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual NodeAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
