package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CapabilitiesFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCapabilitiesFluentImplAssert<S extends AbstractCapabilitiesFluentImplAssert<S, A>, A extends CapabilitiesFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCapabilitiesFluentImplAssert}</code> to make assertions on actual CapabilitiesFluentImpl.
   * @param actual the CapabilitiesFluentImpl we want to make assertions on.
   */
  protected AbstractCapabilitiesFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CapabilitiesFluentImpl's add contains the given String elements.
   * @param add the given elements that should be contained in actual CapabilitiesFluentImpl's add.
   * @return this assertion object.
   * @throws AssertionError if the actual CapabilitiesFluentImpl's add does not contain all given String elements.
   */
  public S hasAdd(String... add) {
    // check that actual CapabilitiesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (add == null) throw new AssertionError("Expecting add parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAdd(), add);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CapabilitiesFluentImpl has no add.
   * @return this assertion object.
   * @throws AssertionError if the actual CapabilitiesFluentImpl's add is not empty.
   */
  public S hasNoAdd() {
    // check that actual CapabilitiesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have add but had :\n  <%s>";
    
    // check
    if (actual.getAdd().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAdd());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CapabilitiesFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CapabilitiesFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CapabilitiesFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CapabilitiesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CapabilitiesFluentImpl's drop contains the given String elements.
   * @param drop the given elements that should be contained in actual CapabilitiesFluentImpl's drop.
   * @return this assertion object.
   * @throws AssertionError if the actual CapabilitiesFluentImpl's drop does not contain all given String elements.
   */
  public S hasDrop(String... drop) {
    // check that actual CapabilitiesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (drop == null) throw new AssertionError("Expecting drop parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDrop(), drop);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CapabilitiesFluentImpl has no drop.
   * @return this assertion object.
   * @throws AssertionError if the actual CapabilitiesFluentImpl's drop is not empty.
   */
  public S hasNoDrop() {
    // check that actual CapabilitiesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have drop but had :\n  <%s>";
    
    // check
    if (actual.getDrop().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getDrop());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
