package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SourceRevisionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceRevisionFluentAssert<S extends AbstractSourceRevisionFluentAssert<S, A>, A extends SourceRevisionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceRevisionFluentAssert}</code> to make assertions on actual SourceRevisionFluent.
   * @param actual the SourceRevisionFluent we want to make assertions on.
   */
  protected AbstractSourceRevisionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SourceRevisionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SourceRevisionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceRevisionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceRevisionFluent's git is equal to the given one.
   * @param git the given git to compare the actual SourceRevisionFluent's git to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceRevisionFluent's git is not equal to the given one.
   */
  public S hasGit(GitSourceRevision git) {
    // check that actual SourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected git of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitSourceRevision actualGit = actual.getGit();
    if (!Objects.areEqual(actualGit, git)) {
      failWithMessage(assertjErrorMessage, actual, git, actualGit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceRevisionFluent's type is equal to the given one.
   * @param type the given type to compare the actual SourceRevisionFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceRevisionFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual SourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
