package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SourceBuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceBuildStrategyAssert<S extends AbstractSourceBuildStrategyAssert<S, A>, A extends SourceBuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceBuildStrategyAssert}</code> to make assertions on actual SourceBuildStrategy.
   * @param actual the SourceBuildStrategy we want to make assertions on.
   */
  protected AbstractSourceBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SourceBuildStrategy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SourceBuildStrategy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceBuildStrategy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceBuildStrategy's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual SourceBuildStrategy's env.
   * @return this assertion object.
   * @throws AssertionError if the actual SourceBuildStrategy's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) throw new AssertionError("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceBuildStrategy has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual SourceBuildStrategy's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SourceBuildStrategy's forcePull is equal to the given one.
   * @param forcePull the given forcePull to compare the actual SourceBuildStrategy's forcePull to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceBuildStrategy's forcePull is not equal to the given one.
   */
  public S hasForcePull(Boolean forcePull) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected forcePull of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualForcePull = actual.getForcePull();
    if (!Objects.areEqual(actualForcePull, forcePull)) {
      failWithMessage(assertjErrorMessage, actual, forcePull, actualForcePull);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceBuildStrategy's from is equal to the given one.
   * @param from the given from to compare the actual SourceBuildStrategy's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceBuildStrategy's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceBuildStrategy's incremental is equal to the given one.
   * @param incremental the given incremental to compare the actual SourceBuildStrategy's incremental to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceBuildStrategy's incremental is not equal to the given one.
   */
  public S hasIncremental(Boolean incremental) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected incremental of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualIncremental = actual.getIncremental();
    if (!Objects.areEqual(actualIncremental, incremental)) {
      failWithMessage(assertjErrorMessage, actual, incremental, actualIncremental);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceBuildStrategy's pullSecret is equal to the given one.
   * @param pullSecret the given pullSecret to compare the actual SourceBuildStrategy's pullSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceBuildStrategy's pullSecret is not equal to the given one.
   */
  public S hasPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected pullSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPullSecret = actual.getPullSecret();
    if (!Objects.areEqual(actualPullSecret, pullSecret)) {
      failWithMessage(assertjErrorMessage, actual, pullSecret, actualPullSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceBuildStrategy's scripts is equal to the given one.
   * @param scripts the given scripts to compare the actual SourceBuildStrategy's scripts to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceBuildStrategy's scripts is not equal to the given one.
   */
  public S hasScripts(String scripts) {
    // check that actual SourceBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected scripts of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualScripts = actual.getScripts();
    if (!Objects.areEqual(actualScripts, scripts)) {
      failWithMessage(assertjErrorMessage, actual, scripts, actualScripts);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
