package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildOutputFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildOutputFluentImplAssert<S extends AbstractBuildOutputFluentImplAssert<S, A>, A extends BuildOutputFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildOutputFluentImplAssert}</code> to make assertions on actual BuildOutputFluentImpl.
   * @param actual the BuildOutputFluentImpl we want to make assertions on.
   */
  protected AbstractBuildOutputFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildOutputFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildOutputFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildOutputFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildOutputFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildOutputFluentImpl's pushSecret is equal to the given one.
   * @param pushSecret the given pushSecret to compare the actual BuildOutputFluentImpl's pushSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildOutputFluentImpl's pushSecret is not equal to the given one.
   */
  public S hasPushSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pushSecret) {
    // check that actual BuildOutputFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected pushSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPushSecret = actual.getPushSecret();
    if (!Objects.areEqual(actualPushSecret, pushSecret)) {
      failWithMessage(assertjErrorMessage, actual, pushSecret, actualPushSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildOutputFluentImpl's to is equal to the given one.
   * @param to the given to to compare the actual BuildOutputFluentImpl's to to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildOutputFluentImpl's to is not equal to the given one.
   */
  public S hasTo(io.fabric8.kubernetes.api.model.ObjectReference to) {
    // check that actual BuildOutputFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected to of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualTo = actual.getTo();
    if (!Objects.areEqual(actualTo, to)) {
      failWithMessage(assertjErrorMessage, actual, to, actualTo);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
