package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildConfigStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildConfigStatusFluentImplAssert<S extends AbstractBuildConfigStatusFluentImplAssert<S, A>, A extends BuildConfigStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildConfigStatusFluentImplAssert}</code> to make assertions on actual BuildConfigStatusFluentImpl.
   * @param actual the BuildConfigStatusFluentImpl we want to make assertions on.
   */
  protected AbstractBuildConfigStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildConfigStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildConfigStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildConfigStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigStatusFluentImpl's lastVersion is equal to the given one.
   * @param lastVersion the given lastVersion to compare the actual BuildConfigStatusFluentImpl's lastVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigStatusFluentImpl's lastVersion is not equal to the given one.
   */
  public S hasLastVersion(Integer lastVersion) {
    // check that actual BuildConfigStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lastVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLastVersion = actual.getLastVersion();
    if (!Objects.areEqual(actualLastVersion, lastVersion)) {
      failWithMessage(assertjErrorMessage, actual, lastVersion, actualLastVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
