package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VolumeFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeFluentImplAssert<S extends AbstractVolumeFluentImplAssert<S, A>, A extends VolumeFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeFluentImplAssert}</code> to make assertions on actual VolumeFluentImpl.
   * @param actual the VolumeFluentImpl we want to make assertions on.
   */
  protected AbstractVolumeFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VolumeFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual VolumeFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's awsElasticBlockStore is equal to the given one.
   * @param awsElasticBlockStore the given awsElasticBlockStore to compare the actual VolumeFluentImpl's awsElasticBlockStore to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's awsElasticBlockStore is not equal to the given one.
   */
  public S hasAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected awsElasticBlockStore of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    AWSElasticBlockStoreVolumeSource actualAwsElasticBlockStore = actual.getAwsElasticBlockStore();
    if (!Objects.areEqual(actualAwsElasticBlockStore, awsElasticBlockStore)) {
      failWithMessage(assertjErrorMessage, actual, awsElasticBlockStore, actualAwsElasticBlockStore);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's cephfs is equal to the given one.
   * @param cephfs the given cephfs to compare the actual VolumeFluentImpl's cephfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's cephfs is not equal to the given one.
   */
  public S hasCephfs(CephFSVolumeSource cephfs) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected cephfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CephFSVolumeSource actualCephfs = actual.getCephfs();
    if (!Objects.areEqual(actualCephfs, cephfs)) {
      failWithMessage(assertjErrorMessage, actual, cephfs, actualCephfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's emptyDir is equal to the given one.
   * @param emptyDir the given emptyDir to compare the actual VolumeFluentImpl's emptyDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's emptyDir is not equal to the given one.
   */
  public S hasEmptyDir(EmptyDirVolumeSource emptyDir) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected emptyDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EmptyDirVolumeSource actualEmptyDir = actual.getEmptyDir();
    if (!Objects.areEqual(actualEmptyDir, emptyDir)) {
      failWithMessage(assertjErrorMessage, actual, emptyDir, actualEmptyDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's gcePersistentDisk is equal to the given one.
   * @param gcePersistentDisk the given gcePersistentDisk to compare the actual VolumeFluentImpl's gcePersistentDisk to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's gcePersistentDisk is not equal to the given one.
   */
  public S hasGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected gcePersistentDisk of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GCEPersistentDiskVolumeSource actualGcePersistentDisk = actual.getGcePersistentDisk();
    if (!Objects.areEqual(actualGcePersistentDisk, gcePersistentDisk)) {
      failWithMessage(assertjErrorMessage, actual, gcePersistentDisk, actualGcePersistentDisk);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's gitRepo is equal to the given one.
   * @param gitRepo the given gitRepo to compare the actual VolumeFluentImpl's gitRepo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's gitRepo is not equal to the given one.
   */
  public S hasGitRepo(GitRepoVolumeSource gitRepo) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected gitRepo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitRepoVolumeSource actualGitRepo = actual.getGitRepo();
    if (!Objects.areEqual(actualGitRepo, gitRepo)) {
      failWithMessage(assertjErrorMessage, actual, gitRepo, actualGitRepo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's glusterfs is equal to the given one.
   * @param glusterfs the given glusterfs to compare the actual VolumeFluentImpl's glusterfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's glusterfs is not equal to the given one.
   */
  public S hasGlusterfs(GlusterfsVolumeSource glusterfs) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected glusterfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GlusterfsVolumeSource actualGlusterfs = actual.getGlusterfs();
    if (!Objects.areEqual(actualGlusterfs, glusterfs)) {
      failWithMessage(assertjErrorMessage, actual, glusterfs, actualGlusterfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's hostPath is equal to the given one.
   * @param hostPath the given hostPath to compare the actual VolumeFluentImpl's hostPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's hostPath is not equal to the given one.
   */
  public S hasHostPath(HostPathVolumeSource hostPath) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HostPathVolumeSource actualHostPath = actual.getHostPath();
    if (!Objects.areEqual(actualHostPath, hostPath)) {
      failWithMessage(assertjErrorMessage, actual, hostPath, actualHostPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's iscsi is equal to the given one.
   * @param iscsi the given iscsi to compare the actual VolumeFluentImpl's iscsi to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's iscsi is not equal to the given one.
   */
  public S hasIscsi(ISCSIVolumeSource iscsi) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected iscsi of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ISCSIVolumeSource actualIscsi = actual.getIscsi();
    if (!Objects.areEqual(actualIscsi, iscsi)) {
      failWithMessage(assertjErrorMessage, actual, iscsi, actualIscsi);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual VolumeFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(MetadataVolumeSource metadata) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    MetadataVolumeSource actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual VolumeFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's nfs is equal to the given one.
   * @param nfs the given nfs to compare the actual VolumeFluentImpl's nfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's nfs is not equal to the given one.
   */
  public S hasNfs(NFSVolumeSource nfs) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NFSVolumeSource actualNfs = actual.getNfs();
    if (!Objects.areEqual(actualNfs, nfs)) {
      failWithMessage(assertjErrorMessage, actual, nfs, actualNfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's persistentVolumeClaim is equal to the given one.
   * @param persistentVolumeClaim the given persistentVolumeClaim to compare the actual VolumeFluentImpl's persistentVolumeClaim to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's persistentVolumeClaim is not equal to the given one.
   */
  public S hasPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentVolumeClaim of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaimVolumeSource actualPersistentVolumeClaim = actual.getPersistentVolumeClaim();
    if (!Objects.areEqual(actualPersistentVolumeClaim, persistentVolumeClaim)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeClaim, actualPersistentVolumeClaim);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's rbd is equal to the given one.
   * @param rbd the given rbd to compare the actual VolumeFluentImpl's rbd to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's rbd is not equal to the given one.
   */
  public S hasRbd(RBDVolumeSource rbd) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected rbd of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RBDVolumeSource actualRbd = actual.getRbd();
    if (!Objects.areEqual(actualRbd, rbd)) {
      failWithMessage(assertjErrorMessage, actual, rbd, actualRbd);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluentImpl's secret is equal to the given one.
   * @param secret the given secret to compare the actual VolumeFluentImpl's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluentImpl's secret is not equal to the given one.
   */
  public S hasSecret(SecretVolumeSource secret) {
    // check that actual VolumeFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecretVolumeSource actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
