package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TypeMetaFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTypeMetaFluentAssert<S extends AbstractTypeMetaFluentAssert<S, A>, A extends TypeMetaFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTypeMetaFluentAssert}</code> to make assertions on actual TypeMetaFluent.
   * @param actual the TypeMetaFluent we want to make assertions on.
   */
  protected AbstractTypeMetaFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TypeMetaFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TypeMetaFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeMetaFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TypeMetaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeMetaFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual TypeMetaFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeMetaFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual TypeMetaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TypeMetaFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual TypeMetaFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TypeMetaFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual TypeMetaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
