package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TCPSocketActionFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTCPSocketActionFluentImplAssert<S extends AbstractTCPSocketActionFluentImplAssert<S, A>, A extends TCPSocketActionFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTCPSocketActionFluentImplAssert}</code> to make assertions on actual TCPSocketActionFluentImpl.
   * @param actual the TCPSocketActionFluentImpl we want to make assertions on.
   */
  protected AbstractTCPSocketActionFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TCPSocketActionFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TCPSocketActionFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TCPSocketActionFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TCPSocketActionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TCPSocketActionFluentImpl's port is equal to the given one.
   * @param port the given port to compare the actual TCPSocketActionFluentImpl's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TCPSocketActionFluentImpl's port is not equal to the given one.
   */
  public S hasPort(IntOrString port) {
    // check that actual TCPSocketActionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    IntOrString actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
