package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PersistentVolumeClaimFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeClaimFluentImplAssert<S extends AbstractPersistentVolumeClaimFluentImplAssert<S, A>, A extends PersistentVolumeClaimFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeClaimFluentImplAssert}</code> to make assertions on actual PersistentVolumeClaimFluentImpl.
   * @param actual the PersistentVolumeClaimFluentImpl we want to make assertions on.
   */
  protected AbstractPersistentVolumeClaimFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PersistentVolumeClaimFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PersistentVolumeClaimFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PersistentVolumeClaimFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual PersistentVolumeClaimFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(PersistentVolumeClaim.ApiVersion apiVersion) {
    // check that actual PersistentVolumeClaimFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaim.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual PersistentVolumeClaimFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual PersistentVolumeClaimFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual PersistentVolumeClaimFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual PersistentVolumeClaimFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimFluentImpl's spec is equal to the given one.
   * @param spec the given spec to compare the actual PersistentVolumeClaimFluentImpl's spec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimFluentImpl's spec is not equal to the given one.
   */
  public S hasSpec(PersistentVolumeClaimSpec spec) {
    // check that actual PersistentVolumeClaimFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected spec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaimSpec actualSpec = actual.getSpec();
    if (!Objects.areEqual(actualSpec, spec)) {
      failWithMessage(assertjErrorMessage, actual, spec, actualSpec);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimFluentImpl's status is equal to the given one.
   * @param status the given status to compare the actual PersistentVolumeClaimFluentImpl's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimFluentImpl's status is not equal to the given one.
   */
  public S hasStatus(PersistentVolumeClaimStatus status) {
    // check that actual PersistentVolumeClaimFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaimStatus actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
