package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LoadBalancerStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLoadBalancerStatusFluentImplAssert<S extends AbstractLoadBalancerStatusFluentImplAssert<S, A>, A extends LoadBalancerStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLoadBalancerStatusFluentImplAssert}</code> to make assertions on actual LoadBalancerStatusFluentImpl.
   * @param actual the LoadBalancerStatusFluentImpl we want to make assertions on.
   */
  protected AbstractLoadBalancerStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LoadBalancerStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LoadBalancerStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LoadBalancerStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LoadBalancerStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LoadBalancerStatusFluentImpl's ingress contains the given LoadBalancerIngress elements.
   * @param ingress the given elements that should be contained in actual LoadBalancerStatusFluentImpl's ingress.
   * @return this assertion object.
   * @throws AssertionError if the actual LoadBalancerStatusFluentImpl's ingress does not contain all given LoadBalancerIngress elements.
   */
  public S hasIngress(LoadBalancerIngress... ingress) {
    // check that actual LoadBalancerStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given LoadBalancerIngress varargs is not null.
    if (ingress == null) throw new AssertionError("Expecting ingress parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getIngress(), ingress);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LoadBalancerStatusFluentImpl has no ingress.
   * @return this assertion object.
   * @throws AssertionError if the actual LoadBalancerStatusFluentImpl's ingress is not empty.
   */
  public S hasNoIngress() {
    // check that actual LoadBalancerStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have ingress but had :\n  <%s>";
    
    // check
    if (actual.getIngress().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getIngress());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
