package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ListMetaFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractListMetaFluentImplAssert<S extends AbstractListMetaFluentImplAssert<S, A>, A extends ListMetaFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractListMetaFluentImplAssert}</code> to make assertions on actual ListMetaFluentImpl.
   * @param actual the ListMetaFluentImpl we want to make assertions on.
   */
  protected AbstractListMetaFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ListMetaFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ListMetaFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMetaFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ListMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ListMetaFluentImpl's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual ListMetaFluentImpl's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMetaFluentImpl's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(String resourceVersion) {
    // check that actual ListMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ListMetaFluentImpl's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual ListMetaFluentImpl's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMetaFluentImpl's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual ListMetaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
