package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CephFSVolumeSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCephFSVolumeSourceFluentImplAssert<S extends AbstractCephFSVolumeSourceFluentImplAssert<S, A>, A extends CephFSVolumeSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCephFSVolumeSourceFluentImplAssert}</code> to make assertions on actual CephFSVolumeSourceFluentImpl.
   * @param actual the CephFSVolumeSourceFluentImpl we want to make assertions on.
   */
  protected AbstractCephFSVolumeSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CephFSVolumeSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CephFSVolumeSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CephFSVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSourceFluentImpl's monitors contains the given String elements.
   * @param monitors the given elements that should be contained in actual CephFSVolumeSourceFluentImpl's monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual CephFSVolumeSourceFluentImpl's monitors does not contain all given String elements.
   */
  public S hasMonitors(String... monitors) {
    // check that actual CephFSVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (monitors == null) throw new AssertionError("Expecting monitors parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMonitors(), monitors);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSourceFluentImpl has no monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual CephFSVolumeSourceFluentImpl's monitors is not empty.
   */
  public S hasNoMonitors() {
    // check that actual CephFSVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have monitors but had :\n  <%s>";
    
    // check
    if (actual.getMonitors().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getMonitors());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CephFSVolumeSourceFluentImpl's secretFile is equal to the given one.
   * @param secretFile the given secretFile to compare the actual CephFSVolumeSourceFluentImpl's secretFile to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSourceFluentImpl's secretFile is not equal to the given one.
   */
  public S hasSecretFile(String secretFile) {
    // check that actual CephFSVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secretFile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecretFile = actual.getSecretFile();
    if (!Objects.areEqual(actualSecretFile, secretFile)) {
      failWithMessage(assertjErrorMessage, actual, secretFile, actualSecretFile);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSourceFluentImpl's secretRef is equal to the given one.
   * @param secretRef the given secretRef to compare the actual CephFSVolumeSourceFluentImpl's secretRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSourceFluentImpl's secretRef is not equal to the given one.
   */
  public S hasSecretRef(LocalObjectReference secretRef) {
    // check that actual CephFSVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secretRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LocalObjectReference actualSecretRef = actual.getSecretRef();
    if (!Objects.areEqual(actualSecretRef, secretRef)) {
      failWithMessage(assertjErrorMessage, actual, secretRef, actualSecretRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSourceFluentImpl's user is equal to the given one.
   * @param user the given user to compare the actual CephFSVolumeSourceFluentImpl's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSourceFluentImpl's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual CephFSVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
