package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RoleBinding} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRoleBindingAssert<S extends AbstractRoleBindingAssert<S, A>, A extends RoleBinding> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRoleBindingAssert}</code> to make assertions on actual RoleBinding.
   * @param actual the RoleBinding we want to make assertions on.
   */
  protected AbstractRoleBindingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RoleBinding's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RoleBinding's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoleBinding's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual RoleBinding's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoleBinding's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(RoleBinding.ApiVersion apiVersion) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RoleBinding.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding's groupNames contains the given String elements.
   * @param groupNames the given elements that should be contained in actual RoleBinding's groupNames.
   * @return this assertion object.
   * @throws AssertionError if the actual RoleBinding's groupNames does not contain all given String elements.
   */
  public S hasGroupNames(String... groupNames) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groupNames == null) throw new AssertionError("Expecting groupNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroupNames(), groupNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding has no groupNames.
   * @return this assertion object.
   * @throws AssertionError if the actual RoleBinding's groupNames is not empty.
   */
  public S hasNoGroupNames() {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have groupNames but had :\n  <%s>";
    
    // check
    if (actual.getGroupNames().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroupNames());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual RoleBinding's kind is equal to the given one.
   * @param kind the given kind to compare the actual RoleBinding's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoleBinding's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual RoleBinding's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoleBinding's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding's roleRef is equal to the given one.
   * @param roleRef the given roleRef to compare the actual RoleBinding's roleRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoleBinding's roleRef is not equal to the given one.
   */
  public S hasRoleRef(io.fabric8.kubernetes.api.model.ObjectReference roleRef) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected roleRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualRoleRef = actual.getRoleRef();
    if (!Objects.areEqual(actualRoleRef, roleRef)) {
      failWithMessage(assertjErrorMessage, actual, roleRef, actualRoleRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding's subjects contains the given io.fabric8.kubernetes.api.model.ObjectReference elements.
   * @param subjects the given elements that should be contained in actual RoleBinding's subjects.
   * @return this assertion object.
   * @throws AssertionError if the actual RoleBinding's subjects does not contain all given io.fabric8.kubernetes.api.model.ObjectReference elements.
   */
  public S hasSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.ObjectReference varargs is not null.
    if (subjects == null) throw new AssertionError("Expecting subjects parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSubjects(), subjects);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding has no subjects.
   * @return this assertion object.
   * @throws AssertionError if the actual RoleBinding's subjects is not empty.
   */
  public S hasNoSubjects() {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have subjects but had :\n  <%s>";
    
    // check
    if (actual.getSubjects().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSubjects());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual RoleBinding's userNames contains the given String elements.
   * @param userNames the given elements that should be contained in actual RoleBinding's userNames.
   * @return this assertion object.
   * @throws AssertionError if the actual RoleBinding's userNames does not contain all given String elements.
   */
  public S hasUserNames(String... userNames) {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (userNames == null) throw new AssertionError("Expecting userNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUserNames(), userNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoleBinding has no userNames.
   * @return this assertion object.
   * @throws AssertionError if the actual RoleBinding's userNames is not empty.
   */
  public S hasNoUserNames() {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have userNames but had :\n  <%s>";
    
    // check
    if (actual.getUserNames().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUserNames());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
