package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WebHookTrigger} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWebHookTriggerAssert<S extends AbstractWebHookTriggerAssert<S, A>, A extends WebHookTrigger> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWebHookTriggerAssert}</code> to make assertions on actual WebHookTrigger.
   * @param actual the WebHookTrigger we want to make assertions on.
   */
  protected AbstractWebHookTriggerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WebHookTrigger's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual WebHookTrigger's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WebHookTrigger's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual WebHookTrigger we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WebHookTrigger's secret is equal to the given one.
   * @param secret the given secret to compare the actual WebHookTrigger's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WebHookTrigger's secret is not equal to the given one.
   */
  public S hasSecret(String secret) {
    // check that actual WebHookTrigger we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
