package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TemplateFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTemplateFluentImplAssert<S extends AbstractTemplateFluentImplAssert<S, A>, A extends TemplateFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTemplateFluentImplAssert}</code> to make assertions on actual TemplateFluentImpl.
   * @param actual the TemplateFluentImpl we want to make assertions on.
   */
  protected AbstractTemplateFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TemplateFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TemplateFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TemplateFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual TemplateFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TemplateFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Template.ApiVersion apiVersion) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Template.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual TemplateFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TemplateFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl's labels is equal to the given one.
   * @param labels the given labels to compare the actual TemplateFluentImpl's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TemplateFluentImpl's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual TemplateFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TemplateFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl's objects contains the given io.fabric8.kubernetes.api.model.HasMetadata elements.
   * @param objects the given elements that should be contained in actual TemplateFluentImpl's objects.
   * @return this assertion object.
   * @throws AssertionError if the actual TemplateFluentImpl's objects does not contain all given io.fabric8.kubernetes.api.model.HasMetadata elements.
   */
  public S hasObjects(io.fabric8.kubernetes.api.model.HasMetadata... objects) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.HasMetadata varargs is not null.
    if (objects == null) throw new AssertionError("Expecting objects parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getObjects(), objects);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl has no objects.
   * @return this assertion object.
   * @throws AssertionError if the actual TemplateFluentImpl's objects is not empty.
   */
  public S hasNoObjects() {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have objects but had :\n  <%s>";
    
    // check
    if (actual.getObjects().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getObjects());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual TemplateFluentImpl's parameters contains the given Parameter elements.
   * @param parameters the given elements that should be contained in actual TemplateFluentImpl's parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual TemplateFluentImpl's parameters does not contain all given Parameter elements.
   */
  public S hasParameters(Parameter... parameters) {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given Parameter varargs is not null.
    if (parameters == null) throw new AssertionError("Expecting parameters parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getParameters(), parameters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TemplateFluentImpl has no parameters.
   * @return this assertion object.
   * @throws AssertionError if the actual TemplateFluentImpl's parameters is not empty.
   */
  public S hasNoParameters() {
    // check that actual TemplateFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have parameters but had :\n  <%s>";
    
    // check
    if (actual.getParameters().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getParameters());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
