package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SourceControlUserFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceControlUserFluentImplAssert<S extends AbstractSourceControlUserFluentImplAssert<S, A>, A extends SourceControlUserFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceControlUserFluentImplAssert}</code> to make assertions on actual SourceControlUserFluentImpl.
   * @param actual the SourceControlUserFluentImpl we want to make assertions on.
   */
  protected AbstractSourceControlUserFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SourceControlUserFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SourceControlUserFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUserFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SourceControlUserFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceControlUserFluentImpl's email is equal to the given one.
   * @param email the given email to compare the actual SourceControlUserFluentImpl's email to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUserFluentImpl's email is not equal to the given one.
   */
  public S hasEmail(String email) {
    // check that actual SourceControlUserFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected email of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualEmail = actual.getEmail();
    if (!Objects.areEqual(actualEmail, email)) {
      failWithMessage(assertjErrorMessage, actual, email, actualEmail);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceControlUserFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual SourceControlUserFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUserFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual SourceControlUserFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
