package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GroupFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGroupFluentImplAssert<S extends AbstractGroupFluentImplAssert<S, A>, A extends GroupFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGroupFluentImplAssert}</code> to make assertions on actual GroupFluentImpl.
   * @param actual the GroupFluentImpl we want to make assertions on.
   */
  protected AbstractGroupFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GroupFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GroupFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GroupFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual GroupFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Group.ApiVersion apiVersion) {
    // check that actual GroupFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Group.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual GroupFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual GroupFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual GroupFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual GroupFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluentImpl's users contains the given String elements.
   * @param users the given elements that should be contained in actual GroupFluentImpl's users.
   * @return this assertion object.
   * @throws AssertionError if the actual GroupFluentImpl's users does not contain all given String elements.
   */
  public S hasUsers(String... users) {
    // check that actual GroupFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) throw new AssertionError("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluentImpl has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual GroupFluentImpl's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual GroupFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
