package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TagEvent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagEventAssert<S extends AbstractTagEventAssert<S, A>, A extends TagEvent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagEventAssert}</code> to make assertions on actual TagEvent.
   * @param actual the TagEvent we want to make assertions on.
   */
  protected AbstractTagEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TagEvent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TagEvent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEvent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEvent's created is equal to the given one.
   * @param created the given created to compare the actual TagEvent's created to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEvent's created is not equal to the given one.
   */
  public S hasCreated(String created) {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected created of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreated = actual.getCreated();
    if (!Objects.areEqual(actualCreated, created)) {
      failWithMessage(assertjErrorMessage, actual, created, actualCreated);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEvent's dockerImageReference is equal to the given one.
   * @param dockerImageReference the given dockerImageReference to compare the actual TagEvent's dockerImageReference to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEvent's dockerImageReference is not equal to the given one.
   */
  public S hasDockerImageReference(String dockerImageReference) {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected dockerImageReference of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageReference = actual.getDockerImageReference();
    if (!Objects.areEqual(actualDockerImageReference, dockerImageReference)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageReference, actualDockerImageReference);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEvent's image is equal to the given one.
   * @param image the given image to compare the actual TagEvent's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEvent's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual TagEvent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
