package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ExecNewPodHook} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractExecNewPodHookAssert<S extends AbstractExecNewPodHookAssert<S, A>, A extends ExecNewPodHook> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractExecNewPodHookAssert}</code> to make assertions on actual ExecNewPodHook.
   * @param actual the ExecNewPodHook we want to make assertions on.
   */
  protected AbstractExecNewPodHookAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ExecNewPodHook's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ExecNewPodHook's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ExecNewPodHook's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ExecNewPodHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHook's command contains the given String elements.
   * @param command the given elements that should be contained in actual ExecNewPodHook's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHook's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual ExecNewPodHook we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) throw new AssertionError("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHook has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHook's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual ExecNewPodHook we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ExecNewPodHook's containerName is equal to the given one.
   * @param containerName the given containerName to compare the actual ExecNewPodHook's containerName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ExecNewPodHook's containerName is not equal to the given one.
   */
  public S hasContainerName(String containerName) {
    // check that actual ExecNewPodHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerName = actual.getContainerName();
    if (!Objects.areEqual(actualContainerName, containerName)) {
      failWithMessage(assertjErrorMessage, actual, containerName, actualContainerName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHook's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual ExecNewPodHook's env.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHook's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual ExecNewPodHook we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) throw new AssertionError("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHook has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHook's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual ExecNewPodHook we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
