package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ClusterRoleFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterRoleFluentImplAssert<S extends AbstractClusterRoleFluentImplAssert<S, A>, A extends ClusterRoleFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterRoleFluentImplAssert}</code> to make assertions on actual ClusterRoleFluentImpl.
   * @param actual the ClusterRoleFluentImpl we want to make assertions on.
   */
  protected AbstractClusterRoleFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ClusterRoleFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ClusterRoleFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRoleFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ClusterRoleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRoleFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ClusterRoleFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRoleFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ClusterRole.ApiVersion apiVersion) {
    // check that actual ClusterRoleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ClusterRole.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRoleFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ClusterRoleFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRoleFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ClusterRoleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRoleFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ClusterRoleFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRoleFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ClusterRoleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRoleFluentImpl's rules contains the given PolicyRule elements.
   * @param rules the given elements that should be contained in actual ClusterRoleFluentImpl's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterRoleFluentImpl's rules does not contain all given PolicyRule elements.
   */
  public S hasRules(PolicyRule... rules) {
    // check that actual ClusterRoleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given PolicyRule varargs is not null.
    if (rules == null) throw new AssertionError("Expecting rules parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRoleFluentImpl has no rules.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterRoleFluentImpl's rules is not empty.
   */
  public S hasNoRules() {
    // check that actual ClusterRoleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have rules but had :\n  <%s>";
    
    // check
    if (actual.getRules().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRules());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
