package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildSpecFluentImplAssert<S extends AbstractBuildSpecFluentImplAssert<S, A>, A extends BuildSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildSpecFluentImplAssert}</code> to make assertions on actual BuildSpecFluentImpl.
   * @param actual the BuildSpecFluentImpl we want to make assertions on.
   */
  protected AbstractBuildSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's output is equal to the given one.
   * @param output the given output to compare the actual BuildSpecFluentImpl's output to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's output is not equal to the given one.
   */
  public S hasOutput(BuildOutput output) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected output of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildOutput actualOutput = actual.getOutput();
    if (!Objects.areEqual(actualOutput, output)) {
      failWithMessage(assertjErrorMessage, actual, output, actualOutput);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's resources is equal to the given one.
   * @param resources the given resources to compare the actual BuildSpecFluentImpl's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's resources is not equal to the given one.
   */
  public S hasResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's revision is equal to the given one.
   * @param revision the given revision to compare the actual BuildSpecFluentImpl's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's revision is not equal to the given one.
   */
  public S hasRevision(SourceRevision revision) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceRevision actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's serviceAccount is equal to the given one.
   * @param serviceAccount the given serviceAccount to compare the actual BuildSpecFluentImpl's serviceAccount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's serviceAccount is not equal to the given one.
   */
  public S hasServiceAccount(String serviceAccount) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServiceAccount = actual.getServiceAccount();
    if (!Objects.areEqual(actualServiceAccount, serviceAccount)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccount, actualServiceAccount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's source is equal to the given one.
   * @param source the given source to compare the actual BuildSpecFluentImpl's source to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's source is not equal to the given one.
   */
  public S hasSource(BuildSource source) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected source of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildSource actualSource = actual.getSource();
    if (!Objects.areEqual(actualSource, source)) {
      failWithMessage(assertjErrorMessage, actual, source, actualSource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSpecFluentImpl's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual BuildSpecFluentImpl's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSpecFluentImpl's strategy is not equal to the given one.
   */
  public S hasStrategy(BuildStrategy strategy) {
    // check that actual BuildSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
