package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EndpointsFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointsFluentImplAssert<S extends AbstractEndpointsFluentImplAssert<S, A>, A extends EndpointsFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointsFluentImplAssert}</code> to make assertions on actual EndpointsFluentImpl.
   * @param actual the EndpointsFluentImpl we want to make assertions on.
   */
  protected AbstractEndpointsFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EndpointsFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EndpointsFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointsFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EndpointsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointsFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual EndpointsFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointsFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Endpoints.ApiVersion apiVersion) {
    // check that actual EndpointsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Endpoints.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointsFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual EndpointsFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointsFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual EndpointsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointsFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual EndpointsFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointsFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual EndpointsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointsFluentImpl's subsets contains the given EndpointSubset elements.
   * @param subsets the given elements that should be contained in actual EndpointsFluentImpl's subsets.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointsFluentImpl's subsets does not contain all given EndpointSubset elements.
   */
  public S hasSubsets(EndpointSubset... subsets) {
    // check that actual EndpointsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointSubset varargs is not null.
    if (subsets == null) throw new AssertionError("Expecting subsets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSubsets(), subsets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointsFluentImpl has no subsets.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointsFluentImpl's subsets is not empty.
   */
  public S hasNoSubsets() {
    // check that actual EndpointsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have subsets but had :\n  <%s>";
    
    // check
    if (actual.getSubsets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSubsets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
