package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PolicyRuleFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPolicyRuleFluentImplAssert<S extends AbstractPolicyRuleFluentImplAssert<S, A>, A extends PolicyRuleFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPolicyRuleFluentImplAssert}</code> to make assertions on actual PolicyRuleFluentImpl.
   * @param actual the PolicyRuleFluentImpl we want to make assertions on.
   */
  protected AbstractPolicyRuleFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PolicyRuleFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyRuleFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl's attributeRestrictions is equal to the given one.
   * @param attributeRestrictions the given attributeRestrictions to compare the actual PolicyRuleFluentImpl's attributeRestrictions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PolicyRuleFluentImpl's attributeRestrictions is not equal to the given one.
   */
  public S hasAttributeRestrictions(io.fabric8.kubernetes.api.model.HasMetadata attributeRestrictions) {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected attributeRestrictions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.HasMetadata actualAttributeRestrictions = actual.getAttributeRestrictions();
    if (!Objects.areEqual(actualAttributeRestrictions, attributeRestrictions)) {
      failWithMessage(assertjErrorMessage, actual, attributeRestrictions, actualAttributeRestrictions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl's nonResourceURLs contains the given String elements.
   * @param nonResourceURLs the given elements that should be contained in actual PolicyRuleFluentImpl's nonResourceURLs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's nonResourceURLs does not contain all given String elements.
   */
  public S hasNonResourceURLs(String... nonResourceURLs) {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (nonResourceURLs == null) throw new AssertionError("Expecting nonResourceURLs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getNonResourceURLs(), nonResourceURLs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl has no nonResourceURLs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's nonResourceURLs is not empty.
   */
  public S hasNoNonResourceURLs() {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have nonResourceURLs but had :\n  <%s>";
    
    // check
    if (actual.getNonResourceURLs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getNonResourceURLs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRuleFluentImpl's resourceNames contains the given String elements.
   * @param resourceNames the given elements that should be contained in actual PolicyRuleFluentImpl's resourceNames.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's resourceNames does not contain all given String elements.
   */
  public S hasResourceNames(String... resourceNames) {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resourceNames == null) throw new AssertionError("Expecting resourceNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getResourceNames(), resourceNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl has no resourceNames.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's resourceNames is not empty.
   */
  public S hasNoResourceNames() {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have resourceNames but had :\n  <%s>";
    
    // check
    if (actual.getResourceNames().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getResourceNames());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRuleFluentImpl's resources contains the given String elements.
   * @param resources the given elements that should be contained in actual PolicyRuleFluentImpl's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's resources does not contain all given String elements.
   */
  public S hasResources(String... resources) {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (resources == null) throw new AssertionError("Expecting resources parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl has no resources.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's resources is not empty.
   */
  public S hasNoResources() {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have resources but had :\n  <%s>";
    
    // check
    if (actual.getResources().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getResources());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PolicyRuleFluentImpl's verbs contains the given String elements.
   * @param verbs the given elements that should be contained in actual PolicyRuleFluentImpl's verbs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's verbs does not contain all given String elements.
   */
  public S hasVerbs(String... verbs) {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (verbs == null) throw new AssertionError("Expecting verbs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVerbs(), verbs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PolicyRuleFluentImpl has no verbs.
   * @return this assertion object.
   * @throws AssertionError if the actual PolicyRuleFluentImpl's verbs is not empty.
   */
  public S hasNoVerbs() {
    // check that actual PolicyRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have verbs but had :\n  <%s>";
    
    // check
    if (actual.getVerbs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVerbs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
