package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentConfigStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentConfigStatusFluentAssert<S extends AbstractDeploymentConfigStatusFluentAssert<S, A>, A extends DeploymentConfigStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentConfigStatusFluentAssert}</code> to make assertions on actual DeploymentConfigStatusFluent.
   * @param actual the DeploymentConfigStatusFluent we want to make assertions on.
   */
  protected AbstractDeploymentConfigStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentConfigStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentConfigStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentConfigStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatusFluent's details is equal to the given one.
   * @param details the given details to compare the actual DeploymentConfigStatusFluent's details to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatusFluent's details is not equal to the given one.
   */
  public S hasDetails(DeploymentDetails details) {
    // check that actual DeploymentConfigStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected details of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentDetails actualDetails = actual.getDetails();
    if (!Objects.areEqual(actualDetails, details)) {
      failWithMessage(assertjErrorMessage, actual, details, actualDetails);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatusFluent's latestVersion is equal to the given one.
   * @param latestVersion the given latestVersion to compare the actual DeploymentConfigStatusFluent's latestVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatusFluent's latestVersion is not equal to the given one.
   */
  public S hasLatestVersion(Integer latestVersion) {
    // check that actual DeploymentConfigStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected latestVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLatestVersion = actual.getLatestVersion();
    if (!Objects.areEqual(actualLatestVersion, latestVersion)) {
      failWithMessage(assertjErrorMessage, actual, latestVersion, actualLatestVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
