package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PersistentVolumeClaimStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeClaimStatusFluentImplAssert<S extends AbstractPersistentVolumeClaimStatusFluentImplAssert<S, A>, A extends PersistentVolumeClaimStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeClaimStatusFluentImplAssert}</code> to make assertions on actual PersistentVolumeClaimStatusFluentImpl.
   * @param actual the PersistentVolumeClaimStatusFluentImpl we want to make assertions on.
   */
  protected AbstractPersistentVolumeClaimStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PersistentVolumeClaimStatusFluentImpl's accessModes contains the given String elements.
   * @param accessModes the given elements that should be contained in actual PersistentVolumeClaimStatusFluentImpl's accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeClaimStatusFluentImpl's accessModes does not contain all given String elements.
   */
  public S hasAccessModes(String... accessModes) {
    // check that actual PersistentVolumeClaimStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (accessModes == null) throw new AssertionError("Expecting accessModes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAccessModes(), accessModes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimStatusFluentImpl has no accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeClaimStatusFluentImpl's accessModes is not empty.
   */
  public S hasNoAccessModes() {
    // check that actual PersistentVolumeClaimStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have accessModes but had :\n  <%s>";
    
    // check
    if (actual.getAccessModes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAccessModes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PersistentVolumeClaimStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PersistentVolumeClaimStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PersistentVolumeClaimStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimStatusFluentImpl's capacity is equal to the given one.
   * @param capacity the given capacity to compare the actual PersistentVolumeClaimStatusFluentImpl's capacity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimStatusFluentImpl's capacity is not equal to the given one.
   */
  public S hasCapacity(java.util.Map capacity) {
    // check that actual PersistentVolumeClaimStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected capacity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualCapacity = actual.getCapacity();
    if (!Objects.areEqual(actualCapacity, capacity)) {
      failWithMessage(assertjErrorMessage, actual, capacity, actualCapacity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimStatusFluentImpl's phase is equal to the given one.
   * @param phase the given phase to compare the actual PersistentVolumeClaimStatusFluentImpl's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimStatusFluentImpl's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual PersistentVolumeClaimStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
