package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedContextFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedContextFluentImplAssert<S extends AbstractNamedContextFluentImplAssert<S, A>, A extends NamedContextFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedContextFluentImplAssert}</code> to make assertions on actual NamedContextFluentImpl.
   * @param actual the NamedContextFluentImpl we want to make assertions on.
   */
  protected AbstractNamedContextFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedContextFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedContextFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedContextFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedContextFluentImpl's context is equal to the given one.
   * @param context the given context to compare the actual NamedContextFluentImpl's context to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedContextFluentImpl's context is not equal to the given one.
   */
  public S hasContext(Context context) {
    // check that actual NamedContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected context of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Context actualContext = actual.getContext();
    if (!Objects.areEqual(actualContext, context)) {
      failWithMessage(assertjErrorMessage, actual, context, actualContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedContextFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual NamedContextFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedContextFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedContextFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
