package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MetadataVolumeSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMetadataVolumeSourceFluentImplAssert<S extends AbstractMetadataVolumeSourceFluentImplAssert<S, A>, A extends MetadataVolumeSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMetadataVolumeSourceFluentImplAssert}</code> to make assertions on actual MetadataVolumeSourceFluentImpl.
   * @param actual the MetadataVolumeSourceFluentImpl we want to make assertions on.
   */
  protected AbstractMetadataVolumeSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual MetadataVolumeSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MetadataVolumeSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual MetadataVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluentImpl's items contains the given MetadataFile elements.
   * @param items the given elements that should be contained in actual MetadataVolumeSourceFluentImpl's items.
   * @return this assertion object.
   * @throws AssertionError if the actual MetadataVolumeSourceFluentImpl's items does not contain all given MetadataFile elements.
   */
  public S hasItems(MetadataFile... items) {
    // check that actual MetadataVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given MetadataFile varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MetadataVolumeSourceFluentImpl has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual MetadataVolumeSourceFluentImpl's items is not empty.
   */
  public S hasNoItems() {
    // check that actual MetadataVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
