package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SELinuxContextStrategyOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSELinuxContextStrategyOptionsAssert<S extends AbstractSELinuxContextStrategyOptionsAssert<S, A>, A extends SELinuxContextStrategyOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSELinuxContextStrategyOptionsAssert}</code> to make assertions on actual SELinuxContextStrategyOptions.
   * @param actual the SELinuxContextStrategyOptions we want to make assertions on.
   */
  protected AbstractSELinuxContextStrategyOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SELinuxContextStrategyOptions's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SELinuxContextStrategyOptions's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxContextStrategyOptions's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SELinuxContextStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxContextStrategyOptions's seLinuxOptions is equal to the given one.
   * @param seLinuxOptions the given seLinuxOptions to compare the actual SELinuxContextStrategyOptions's seLinuxOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxContextStrategyOptions's seLinuxOptions is not equal to the given one.
   */
  public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    // check that actual SELinuxContextStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxOptions actualSeLinuxOptions = actual.getSeLinuxOptions();
    if (!Objects.areEqual(actualSeLinuxOptions, seLinuxOptions)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxOptions, actualSeLinuxOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxContextStrategyOptions's type is equal to the given one.
   * @param type the given type to compare the actual SELinuxContextStrategyOptions's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxContextStrategyOptions's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual SELinuxContextStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
