/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceSpec;
import io.fabric8.kubernetes.api.model.NamespaceSpecBuilder;
import io.fabric8.kubernetes.api.model.NamespaceSpecFluent;
import io.fabric8.kubernetes.api.model.NamespaceStatus;
import io.fabric8.kubernetes.api.model.NamespaceStatusBuilder;
import io.fabric8.kubernetes.api.model.NamespaceStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.HashMap;
import java.util.Map;

public class NamespaceFluent<T extends NamespaceFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Namespace.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<NamespaceSpec, ?> spec;
    VisitableBuilder<NamespaceStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Namespace.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Namespace.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public NamespaceSpec getSpec() {
        return this.spec != null ? (NamespaceSpec)this.spec.build() : null;
    }

    public T withSpec(NamespaceSpec spec) {
        if (spec != null) {
            this.spec = new NamespaceSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)((Object)this);
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(NamespaceSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public NamespaceStatus getStatus() {
        return this.status != null ? (NamespaceStatus)this.status.build() : null;
    }

    public T withStatus(NamespaceStatus status) {
        if (status != null) {
            this.status = new NamespaceStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)((Object)this);
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public StatusNested<T> withNewStatusLike(NamespaceStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public T withNewStatus(String phase) {
        return this.withStatus(new NamespaceStatus(phase));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class StatusNested<N>
    extends NamespaceStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final NamespaceStatusBuilder builder;

        StatusNested(NamespaceStatus item) {
            this.builder = new NamespaceStatusBuilder(this, item);
        }

        StatusNested() {
            this.builder = new NamespaceStatusBuilder(this);
        }

        public N and() {
            return (N)NamespaceFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends NamespaceSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final NamespaceSpecBuilder builder;

        SpecNested() {
            this.builder = new NamespaceSpecBuilder(this);
        }

        SpecNested(NamespaceSpec item) {
            this.builder = new NamespaceSpecBuilder(this, item);
        }

        public N endSpec() {
            return this.and();
        }

        public N and() {
            return (N)NamespaceFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
            return (N)NamespaceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

