/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubeSchema;
import io.fabric8.kubernetes.api.model.KubeSchemaFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class KubeSchemaBuilder
extends KubeSchemaFluent<KubeSchemaBuilder>
implements VisitableBuilder<KubeSchema, KubeSchemaBuilder> {
    KubeSchemaFluent<?> fluent;

    public KubeSchemaBuilder() {
        this(new KubeSchema());
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent) {
        this(fluent, new KubeSchema());
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent, KubeSchema instance) {
        this.fluent = fluent;
        fluent.withBaseKubernetesList(instance.getBaseKubernetesList());
        fluent.withBuildConfigList(instance.getBuildConfigList());
        fluent.withBuildList(instance.getBuildList());
        fluent.withBuildRequest(instance.getBuildRequest());
        fluent.withConfig(instance.getConfig());
        fluent.withContainerStatus(instance.getContainerStatus());
        fluent.withDeploymentConfigList(instance.getDeploymentConfigList());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withEndpointsList(instance.getEndpointsList());
        fluent.withEnvVar(instance.getEnvVar());
        fluent.withImageList(instance.getImageList());
        fluent.withImageStreamList(instance.getImageStreamList());
        fluent.withNamespace(instance.getNamespace());
        fluent.withNamespaceList(instance.getNamespaceList());
        fluent.withNode(instance.getNode());
        fluent.withNodeList(instance.getNodeList());
        fluent.withOAuthAccessToken(instance.getOAuthAccessToken());
        fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList());
        fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken());
        fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList());
        fluent.withOAuthClient(instance.getOAuthClient());
        fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization());
        fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList());
        fluent.withOAuthClientList(instance.getOAuthClientList());
        fluent.withObjectMeta(instance.getObjectMeta());
        fluent.withPodList(instance.getPodList());
        fluent.withQuantity(instance.getQuantity());
        fluent.withReplicationControllerList(instance.getReplicationControllerList());
        fluent.withRouteList(instance.getRouteList());
        fluent.withSecret(instance.getSecret());
        fluent.withSecretList(instance.getSecretList());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withServiceAccountList(instance.getServiceAccountList());
        fluent.withServiceList(instance.getServiceList());
        fluent.withStatusError(instance.getStatusError());
        fluent.withTagEvent(instance.getTagEvent());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTemplateList(instance.getTemplateList());
        fluent.withWatchEvent(instance.getWatchEvent());
    }

    public KubeSchemaBuilder(KubeSchema instance) {
        this.fluent = this;
        this.withBaseKubernetesList(instance.getBaseKubernetesList());
        this.withBuildConfigList(instance.getBuildConfigList());
        this.withBuildList(instance.getBuildList());
        this.withBuildRequest(instance.getBuildRequest());
        this.withConfig(instance.getConfig());
        this.withContainerStatus(instance.getContainerStatus());
        this.withDeploymentConfigList(instance.getDeploymentConfigList());
        this.withEndpoints(instance.getEndpoints());
        this.withEndpointsList(instance.getEndpointsList());
        this.withEnvVar(instance.getEnvVar());
        this.withImageList(instance.getImageList());
        this.withImageStreamList(instance.getImageStreamList());
        this.withNamespace(instance.getNamespace());
        this.withNamespaceList(instance.getNamespaceList());
        this.withNode(instance.getNode());
        this.withNodeList(instance.getNodeList());
        this.withOAuthAccessToken(instance.getOAuthAccessToken());
        this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList());
        this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken());
        this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList());
        this.withOAuthClient(instance.getOAuthClient());
        this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization());
        this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList());
        this.withOAuthClientList(instance.getOAuthClientList());
        this.withObjectMeta(instance.getObjectMeta());
        this.withPodList(instance.getPodList());
        this.withQuantity(instance.getQuantity());
        this.withReplicationControllerList(instance.getReplicationControllerList());
        this.withRouteList(instance.getRouteList());
        this.withSecret(instance.getSecret());
        this.withSecretList(instance.getSecretList());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountList(instance.getServiceAccountList());
        this.withServiceList(instance.getServiceList());
        this.withStatusError(instance.getStatusError());
        this.withTagEvent(instance.getTagEvent());
        this.withTemplate(instance.getTemplate());
        this.withTemplateList(instance.getTemplateList());
        this.withWatchEvent(instance.getWatchEvent());
    }

    public KubeSchema build() {
        KubeSchema buildable = new KubeSchema(this.fluent.getBaseKubernetesList(), this.fluent.getBuildConfigList(), this.fluent.getBuildList(), this.fluent.getBuildRequest(), this.fluent.getConfig(), this.fluent.getContainerStatus(), this.fluent.getDeploymentConfigList(), this.fluent.getEndpoints(), this.fluent.getEndpointsList(), this.fluent.getEnvVar(), this.fluent.getImageList(), this.fluent.getImageStreamList(), this.fluent.getNamespace(), this.fluent.getNamespaceList(), this.fluent.getNode(), this.fluent.getNodeList(), this.fluent.getOAuthAccessToken(), this.fluent.getOAuthAccessTokenList(), this.fluent.getOAuthAuthorizeToken(), this.fluent.getOAuthAuthorizeTokenList(), this.fluent.getOAuthClient(), this.fluent.getOAuthClientAuthorization(), this.fluent.getOAuthClientAuthorizationList(), this.fluent.getOAuthClientList(), this.fluent.getObjectMeta(), this.fluent.getPodList(), this.fluent.getQuantity(), this.fluent.getReplicationControllerList(), this.fluent.getRouteList(), this.fluent.getSecret(), this.fluent.getSecretList(), this.fluent.getServiceAccount(), this.fluent.getServiceAccountList(), this.fluent.getServiceList(), this.fluent.getStatusError(), this.fluent.getTagEvent(), this.fluent.getTemplate(), this.fluent.getTemplateList(), this.fluent.getWatchEvent());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

