/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterFluent<T extends ClusterFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String apiVersion;
    String certificateAuthority;
    String certificateAuthorityData;
    List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();
    Boolean insecureSkipTlsVerify;
    String server;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public T withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return (T)((Object)this);
    }

    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    public T withCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
        return (T)((Object)this);
    }

    public T addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<NamedExtension> getExtensions() {
        return this.build(this.extensions);
    }

    public T withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)((Object)this);
    }

    public T withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)((Object)this);
    }

    public ExtensionsNested<T> addNewExtension() {
        return new ExtensionsNested();
    }

    public ExtensionsNested<T> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(item);
    }

    public Boolean isInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    public T withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        return (T)((Object)this);
    }

    public String getServer() {
        return this.server;
    }

    public T withServer(String server) {
        this.server = server;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ClusterFluent that = (ClusterFluent)((Object)o);
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.certificateAuthority != null ? !this.certificateAuthority.equals(that.certificateAuthority) : that.certificateAuthority != null) {
            return false;
        }
        if (this.certificateAuthorityData != null ? !this.certificateAuthorityData.equals(that.certificateAuthorityData) : that.certificateAuthorityData != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.insecureSkipTlsVerify != null ? !this.insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) : that.insecureSkipTlsVerify != null) {
            return false;
        }
        if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNested(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNested() {
            this.builder = new NamedExtensionBuilder(this);
        }

        public N and() {
            return (N)ClusterFluent.this.addToExtensions(this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }
}

