package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link OAuthAccessToken} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOAuthAccessTokenAssert<S extends AbstractOAuthAccessTokenAssert<S, A>, A extends OAuthAccessToken> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOAuthAccessTokenAssert}</code> to make assertions on actual OAuthAccessToken.
   * @param actual the OAuthAccessToken we want to make assertions on.
   */
  protected AbstractOAuthAccessTokenAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual OAuthAccessToken's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual OAuthAccessToken's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual OAuthAccessToken's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(OAuthAccessToken.ApiVersion apiVersion) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    OAuthAccessToken.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's authorizeToken is equal to the given one.
   * @param authorizeToken the given authorizeToken to compare the actual OAuthAccessToken's authorizeToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's authorizeToken is not equal to the given one.
   */
  public S hasAuthorizeToken(String authorizeToken) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected authorizeToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualAuthorizeToken = actual.getAuthorizeToken();
    if (!Objects.areEqual(actualAuthorizeToken, authorizeToken)) {
      failWithMessage(assertjErrorMessage, actual, authorizeToken, actualAuthorizeToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's clientName is equal to the given one.
   * @param clientName the given clientName to compare the actual OAuthAccessToken's clientName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's clientName is not equal to the given one.
   */
  public S hasClientName(String clientName) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clientName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientName = actual.getClientName();
    if (!Objects.areEqual(actualClientName, clientName)) {
      failWithMessage(assertjErrorMessage, actual, clientName, actualClientName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's expiresIn is equal to the given one.
   * @param expiresIn the given expiresIn to compare the actual OAuthAccessToken's expiresIn to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's expiresIn is not equal to the given one.
   */
  public S hasExpiresIn(Long expiresIn) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected expiresIn of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualExpiresIn = actual.getExpiresIn();
    if (!Objects.areEqual(actualExpiresIn, expiresIn)) {
      failWithMessage(assertjErrorMessage, actual, expiresIn, actualExpiresIn);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's kind is equal to the given one.
   * @param kind the given kind to compare the actual OAuthAccessToken's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual OAuthAccessToken's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's redirectURI is equal to the given one.
   * @param redirectURI the given redirectURI to compare the actual OAuthAccessToken's redirectURI to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's redirectURI is not equal to the given one.
   */
  public S hasRedirectURI(String redirectURI) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected redirectURI of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRedirectURI = actual.getRedirectURI();
    if (!Objects.areEqual(actualRedirectURI, redirectURI)) {
      failWithMessage(assertjErrorMessage, actual, redirectURI, actualRedirectURI);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's refreshToken is equal to the given one.
   * @param refreshToken the given refreshToken to compare the actual OAuthAccessToken's refreshToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's refreshToken is not equal to the given one.
   */
  public S hasRefreshToken(String refreshToken) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected refreshToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRefreshToken = actual.getRefreshToken();
    if (!Objects.areEqual(actualRefreshToken, refreshToken)) {
      failWithMessage(assertjErrorMessage, actual, refreshToken, actualRefreshToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's scopes contains the given String elements.
   * @param scopes the given elements that should be contained in actual OAuthAccessToken's scopes.
   * @return this assertion object.
   * @throws AssertionError if the actual OAuthAccessToken's scopes does not contain all given String elements.
   */
  public S hasScopes(String... scopes) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (scopes == null) throw new AssertionError("Expecting scopes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getScopes(), scopes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken has no scopes.
   * @return this assertion object.
   * @throws AssertionError if the actual OAuthAccessToken's scopes is not empty.
   */
  public S hasNoScopes() {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have scopes but had :\n  <%s>";
    
    // check
    if (actual.getScopes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getScopes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual OAuthAccessToken's userName is equal to the given one.
   * @param userName the given userName to compare the actual OAuthAccessToken's userName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's userName is not equal to the given one.
   */
  public S hasUserName(String userName) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected userName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUserName = actual.getUserName();
    if (!Objects.areEqual(actualUserName, userName)) {
      failWithMessage(assertjErrorMessage, actual, userName, actualUserName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthAccessToken's userUID is equal to the given one.
   * @param userUID the given userUID to compare the actual OAuthAccessToken's userUID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAccessToken's userUID is not equal to the given one.
   */
  public S hasUserUID(String userUID) {
    // check that actual OAuthAccessToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected userUID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUserUID = actual.getUserUID();
    if (!Objects.areEqual(actualUserUID, userUID)) {
      failWithMessage(assertjErrorMessage, actual, userUID, actualUserUID);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
