package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContextFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContextFluentAssert<S extends AbstractContextFluentAssert<S, A>, A extends ContextFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContextFluentAssert}</code> to make assertions on actual ContextFluent.
   * @param actual the ContextFluent we want to make assertions on.
   */
  protected AbstractContextFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContextFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContextFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluent's cluster is equal to the given one.
   * @param cluster the given cluster to compare the actual ContextFluent's cluster to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluent's cluster is not equal to the given one.
   */
  public S hasCluster(String cluster) {
    // check that actual ContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected cluster of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCluster = actual.getCluster();
    if (!Objects.areEqual(actualCluster, cluster)) {
      failWithMessage(assertjErrorMessage, actual, cluster, actualCluster);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluent's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual ContextFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ContextFluent's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual ContextFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) throw new AssertionError("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluent has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ContextFluent's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual ContextFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContextFluent's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual ContextFluent's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluent's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual ContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContextFluent's user is equal to the given one.
   * @param user the given user to compare the actual ContextFluent's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContextFluent's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual ContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
