package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CustomDeploymentStrategyParams} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomDeploymentStrategyParamsAssert<S extends AbstractCustomDeploymentStrategyParamsAssert<S, A>, A extends CustomDeploymentStrategyParams> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomDeploymentStrategyParamsAssert}</code> to make assertions on actual CustomDeploymentStrategyParams.
   * @param actual the CustomDeploymentStrategyParams we want to make assertions on.
   */
  protected AbstractCustomDeploymentStrategyParamsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParams's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CustomDeploymentStrategyParams's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomDeploymentStrategyParams's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParams's command contains the given String elements.
   * @param command the given elements that should be contained in actual CustomDeploymentStrategyParams's command.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParams's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) throw new AssertionError("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParams has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParams's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomDeploymentStrategyParams's environment contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param environment the given elements that should be contained in actual CustomDeploymentStrategyParams's environment.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParams's environment does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnvironment(io.fabric8.kubernetes.api.model.EnvVar... environment) {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (environment == null) throw new AssertionError("Expecting environment parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnvironment(), environment);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParams has no environment.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParams's environment is not empty.
   */
  public S hasNoEnvironment() {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have environment but had :\n  <%s>";
    
    // check
    if (actual.getEnvironment().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnvironment());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomDeploymentStrategyParams's image is equal to the given one.
   * @param image the given image to compare the actual CustomDeploymentStrategyParams's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomDeploymentStrategyParams's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
