package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ReplicationControllerSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicationControllerSpecAssert<S extends AbstractReplicationControllerSpecAssert<S, A>, A extends ReplicationControllerSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicationControllerSpecAssert}</code> to make assertions on actual ReplicationControllerSpec.
   * @param actual the ReplicationControllerSpec we want to make assertions on.
   */
  protected AbstractReplicationControllerSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ReplicationControllerSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ReplicationControllerSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ReplicationControllerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerSpec's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ReplicationControllerSpec's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpec's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ReplicationControllerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerSpec's selector is equal to the given one.
   * @param selector the given selector to compare the actual ReplicationControllerSpec's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpec's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual ReplicationControllerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerSpec's template is equal to the given one.
   * @param template the given template to compare the actual ReplicationControllerSpec's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerSpec's template is not equal to the given one.
   */
  public S hasTemplate(PodTemplateSpec template) {
    // check that actual ReplicationControllerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
