package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ListMetaFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractListMetaFluentAssert<S extends AbstractListMetaFluentAssert<S, A>, A extends ListMetaFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractListMetaFluentAssert}</code> to make assertions on actual ListMetaFluent.
   * @param actual the ListMetaFluent we want to make assertions on.
   */
  protected AbstractListMetaFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ListMetaFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ListMetaFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMetaFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ListMetaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ListMetaFluent's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual ListMetaFluent's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMetaFluent's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(String resourceVersion) {
    // check that actual ListMetaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ListMetaFluent's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual ListMetaFluent's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ListMetaFluent's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual ListMetaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
