package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ReplicationControllerStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicationControllerStatusFluentAssert<S extends AbstractReplicationControllerStatusFluentAssert<S, A>, A extends ReplicationControllerStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicationControllerStatusFluentAssert}</code> to make assertions on actual ReplicationControllerStatusFluent.
   * @param actual the ReplicationControllerStatusFluent we want to make assertions on.
   */
  protected AbstractReplicationControllerStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ReplicationControllerStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ReplicationControllerStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ReplicationControllerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerStatusFluent's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual ReplicationControllerStatusFluent's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerStatusFluent's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual ReplicationControllerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerStatusFluent's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ReplicationControllerStatusFluent's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerStatusFluent's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ReplicationControllerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
