package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WebHookTriggerFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWebHookTriggerFluentAssert<S extends AbstractWebHookTriggerFluentAssert<S, A>, A extends WebHookTriggerFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWebHookTriggerFluentAssert}</code> to make assertions on actual WebHookTriggerFluent.
   * @param actual the WebHookTriggerFluent we want to make assertions on.
   */
  protected AbstractWebHookTriggerFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WebHookTriggerFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual WebHookTriggerFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WebHookTriggerFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual WebHookTriggerFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WebHookTriggerFluent's secret is equal to the given one.
   * @param secret the given secret to compare the actual WebHookTriggerFluent's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WebHookTriggerFluent's secret is not equal to the given one.
   */
  public S hasSecret(String secret) {
    // check that actual WebHookTriggerFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
