package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TLSConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTLSConfigAssert<S extends AbstractTLSConfigAssert<S, A>, A extends TLSConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTLSConfigAssert}</code> to make assertions on actual TLSConfig.
   * @param actual the TLSConfig we want to make assertions on.
   */
  protected AbstractTLSConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TLSConfig's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TLSConfig's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TLSConfig's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TLSConfig's caCertificate is equal to the given one.
   * @param caCertificate the given caCertificate to compare the actual TLSConfig's caCertificate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TLSConfig's caCertificate is not equal to the given one.
   */
  public S hasCaCertificate(String caCertificate) {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected caCertificate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCaCertificate = actual.getCaCertificate();
    if (!Objects.areEqual(actualCaCertificate, caCertificate)) {
      failWithMessage(assertjErrorMessage, actual, caCertificate, actualCaCertificate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TLSConfig's certificate is equal to the given one.
   * @param certificate the given certificate to compare the actual TLSConfig's certificate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TLSConfig's certificate is not equal to the given one.
   */
  public S hasCertificate(String certificate) {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected certificate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCertificate = actual.getCertificate();
    if (!Objects.areEqual(actualCertificate, certificate)) {
      failWithMessage(assertjErrorMessage, actual, certificate, actualCertificate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TLSConfig's destinationCACertificate is equal to the given one.
   * @param destinationCACertificate the given destinationCACertificate to compare the actual TLSConfig's destinationCACertificate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TLSConfig's destinationCACertificate is not equal to the given one.
   */
  public S hasDestinationCACertificate(String destinationCACertificate) {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected destinationCACertificate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDestinationCACertificate = actual.getDestinationCACertificate();
    if (!Objects.areEqual(actualDestinationCACertificate, destinationCACertificate)) {
      failWithMessage(assertjErrorMessage, actual, destinationCACertificate, actualDestinationCACertificate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TLSConfig's key is equal to the given one.
   * @param key the given key to compare the actual TLSConfig's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TLSConfig's key is not equal to the given one.
   */
  public S hasKey(String key) {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKey = actual.getKey();
    if (!Objects.areEqual(actualKey, key)) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TLSConfig's termination is equal to the given one.
   * @param termination the given termination to compare the actual TLSConfig's termination to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TLSConfig's termination is not equal to the given one.
   */
  public S hasTermination(String termination) {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected termination of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTermination = actual.getTermination();
    if (!Objects.areEqual(actualTermination, termination)) {
      failWithMessage(assertjErrorMessage, actual, termination, actualTermination);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
