package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RouteSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteSpecAssert<S extends AbstractRouteSpecAssert<S, A>, A extends RouteSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteSpecAssert}</code> to make assertions on actual RouteSpec.
   * @param actual the RouteSpec we want to make assertions on.
   */
  protected AbstractRouteSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RouteSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RouteSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteSpec's host is equal to the given one.
   * @param host the given host to compare the actual RouteSpec's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteSpec's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteSpec's path is equal to the given one.
   * @param path the given path to compare the actual RouteSpec's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteSpec's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteSpec's tls is equal to the given one.
   * @param tls the given tls to compare the actual RouteSpec's tls to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteSpec's tls is not equal to the given one.
   */
  public S hasTls(TLSConfig tls) {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected tls of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    TLSConfig actualTls = actual.getTls();
    if (!Objects.areEqual(actualTls, tls)) {
      failWithMessage(assertjErrorMessage, actual, tls, actualTls);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteSpec's to is equal to the given one.
   * @param to the given to to compare the actual RouteSpec's to to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteSpec's to is not equal to the given one.
   */
  public S hasTo(io.fabric8.kubernetes.api.model.ObjectReference to) {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected to of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualTo = actual.getTo();
    if (!Objects.areEqual(actualTo, to)) {
      failWithMessage(assertjErrorMessage, actual, to, actualTo);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
