package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServiceAccount} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceAccountAssert<S extends AbstractServiceAccountAssert<S, A>, A extends ServiceAccount> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceAccountAssert}</code> to make assertions on actual ServiceAccount.
   * @param actual the ServiceAccount we want to make assertions on.
   */
  protected AbstractServiceAccountAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServiceAccount's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServiceAccount's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ServiceAccount's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ServiceAccount.ApiVersion apiVersion) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceAccount.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's imagePullSecrets contains the given LocalObjectReference elements.
   * @param imagePullSecrets the given elements that should be contained in actual ServiceAccount's imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's imagePullSecrets does not contain all given LocalObjectReference elements.
   */
  public S hasImagePullSecrets(LocalObjectReference... imagePullSecrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given LocalObjectReference varargs is not null.
    if (imagePullSecrets == null) throw new AssertionError("Expecting imagePullSecrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImagePullSecrets(), imagePullSecrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount has no imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's imagePullSecrets is not empty.
   */
  public S hasNoImagePullSecrets() {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have imagePullSecrets but had :\n  <%s>";
    
    // check
    if (actual.getImagePullSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImagePullSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ServiceAccount's kind is equal to the given one.
   * @param kind the given kind to compare the actual ServiceAccount's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ServiceAccount's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's secrets contains the given ObjectReference elements.
   * @param secrets the given elements that should be contained in actual ServiceAccount's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's secrets does not contain all given ObjectReference elements.
   */
  public S hasSecrets(ObjectReference... secrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given ObjectReference varargs is not null.
    if (secrets == null) throw new AssertionError("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount has no secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's secrets is not empty.
   */
  public S hasNoSecrets() {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have secrets but had :\n  <%s>";
    
    // check
    if (actual.getSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
