package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link User} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractUserAssert<S extends AbstractUserAssert<S, A>, A extends User> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractUserAssert}</code> to make assertions on actual User.
   * @param actual the User we want to make assertions on.
   */
  protected AbstractUserAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual User's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual User's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual User's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual User's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual User's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual User's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(User.ApiVersion apiVersion) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    User.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual User's fullName is equal to the given one.
   * @param fullName the given fullName to compare the actual User's fullName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual User's fullName is not equal to the given one.
   */
  public S hasFullName(String fullName) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected fullName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFullName = actual.getFullName();
    if (!Objects.areEqual(actualFullName, fullName)) {
      failWithMessage(assertjErrorMessage, actual, fullName, actualFullName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual User's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual User's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual User's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) throw new AssertionError("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual User has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual User's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual User's identities contains the given String elements.
   * @param identities the given elements that should be contained in actual User's identities.
   * @return this assertion object.
   * @throws AssertionError if the actual User's identities does not contain all given String elements.
   */
  public S hasIdentities(String... identities) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (identities == null) throw new AssertionError("Expecting identities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getIdentities(), identities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual User has no identities.
   * @return this assertion object.
   * @throws AssertionError if the actual User's identities is not empty.
   */
  public S hasNoIdentities() {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have identities but had :\n  <%s>";
    
    // check
    if (actual.getIdentities().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getIdentities());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual User's kind is equal to the given one.
   * @param kind the given kind to compare the actual User's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual User's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual User's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual User's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual User's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual User we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
