package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedAuthInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedAuthInfoAssert<S extends AbstractNamedAuthInfoAssert<S, A>, A extends NamedAuthInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedAuthInfoAssert}</code> to make assertions on actual NamedAuthInfo.
   * @param actual the NamedAuthInfo we want to make assertions on.
   */
  protected AbstractNamedAuthInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedAuthInfo's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedAuthInfo's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedAuthInfo's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedAuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedAuthInfo's name is equal to the given one.
   * @param name the given name to compare the actual NamedAuthInfo's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedAuthInfo's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedAuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedAuthInfo's user is equal to the given one.
   * @param user the given user to compare the actual NamedAuthInfo's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedAuthInfo's user is not equal to the given one.
   */
  public S hasUser(AuthInfo user) {
    // check that actual NamedAuthInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    AuthInfo actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
