package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SourceControlUserFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceControlUserFluentAssert<S extends AbstractSourceControlUserFluentAssert<S, A>, A extends SourceControlUserFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceControlUserFluentAssert}</code> to make assertions on actual SourceControlUserFluent.
   * @param actual the SourceControlUserFluent we want to make assertions on.
   */
  protected AbstractSourceControlUserFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SourceControlUserFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SourceControlUserFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUserFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SourceControlUserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceControlUserFluent's email is equal to the given one.
   * @param email the given email to compare the actual SourceControlUserFluent's email to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUserFluent's email is not equal to the given one.
   */
  public S hasEmail(String email) {
    // check that actual SourceControlUserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected email of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualEmail = actual.getEmail();
    if (!Objects.areEqual(actualEmail, email)) {
      failWithMessage(assertjErrorMessage, actual, email, actualEmail);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceControlUserFluent's name is equal to the given one.
   * @param name the given name to compare the actual SourceControlUserFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUserFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual SourceControlUserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
