package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link OAuthClientAuthorizationFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOAuthClientAuthorizationFluentAssert<S extends AbstractOAuthClientAuthorizationFluentAssert<S, A>, A extends OAuthClientAuthorizationFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOAuthClientAuthorizationFluentAssert}</code> to make assertions on actual OAuthClientAuthorizationFluent.
   * @param actual the OAuthClientAuthorizationFluent we want to make assertions on.
   */
  protected AbstractOAuthClientAuthorizationFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual OAuthClientAuthorizationFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual OAuthClientAuthorizationFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(OAuthClientAuthorization.ApiVersion apiVersion) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    OAuthClientAuthorization.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's clientName is equal to the given one.
   * @param clientName the given clientName to compare the actual OAuthClientAuthorizationFluent's clientName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's clientName is not equal to the given one.
   */
  public S hasClientName(String clientName) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clientName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientName = actual.getClientName();
    if (!Objects.areEqual(actualClientName, clientName)) {
      failWithMessage(assertjErrorMessage, actual, clientName, actualClientName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual OAuthClientAuthorizationFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual OAuthClientAuthorizationFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's scopes contains the given String elements.
   * @param scopes the given elements that should be contained in actual OAuthClientAuthorizationFluent's scopes.
   * @return this assertion object.
   * @throws AssertionError if the actual OAuthClientAuthorizationFluent's scopes does not contain all given String elements.
   */
  public S hasScopes(String... scopes) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (scopes == null) throw new AssertionError("Expecting scopes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getScopes(), scopes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent has no scopes.
   * @return this assertion object.
   * @throws AssertionError if the actual OAuthClientAuthorizationFluent's scopes is not empty.
   */
  public S hasNoScopes() {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have scopes but had :\n  <%s>";
    
    // check
    if (actual.getScopes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getScopes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's userName is equal to the given one.
   * @param userName the given userName to compare the actual OAuthClientAuthorizationFluent's userName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's userName is not equal to the given one.
   */
  public S hasUserName(String userName) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected userName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUserName = actual.getUserName();
    if (!Objects.areEqual(actualUserName, userName)) {
      failWithMessage(assertjErrorMessage, actual, userName, actualUserName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientAuthorizationFluent's userUID is equal to the given one.
   * @param userUID the given userUID to compare the actual OAuthClientAuthorizationFluent's userUID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientAuthorizationFluent's userUID is not equal to the given one.
   */
  public S hasUserUID(String userUID) {
    // check that actual OAuthClientAuthorizationFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected userUID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUserUID = actual.getUserUID();
    if (!Objects.areEqual(actualUserUID, userUID)) {
      failWithMessage(assertjErrorMessage, actual, userUID, actualUserUID);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
