package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildTriggerPolicyFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildTriggerPolicyFluentAssert<S extends AbstractBuildTriggerPolicyFluentAssert<S, A>, A extends BuildTriggerPolicyFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildTriggerPolicyFluentAssert}</code> to make assertions on actual BuildTriggerPolicyFluent.
   * @param actual the BuildTriggerPolicyFluent we want to make assertions on.
   */
  protected AbstractBuildTriggerPolicyFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildTriggerPolicyFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildTriggerPolicyFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildTriggerPolicyFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildTriggerPolicyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildTriggerPolicyFluent's generic is equal to the given one.
   * @param generic the given generic to compare the actual BuildTriggerPolicyFluent's generic to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildTriggerPolicyFluent's generic is not equal to the given one.
   */
  public S hasGeneric(WebHookTrigger generic) {
    // check that actual BuildTriggerPolicyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected generic of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    WebHookTrigger actualGeneric = actual.getGeneric();
    if (!Objects.areEqual(actualGeneric, generic)) {
      failWithMessage(assertjErrorMessage, actual, generic, actualGeneric);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildTriggerPolicyFluent's github is equal to the given one.
   * @param github the given github to compare the actual BuildTriggerPolicyFluent's github to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildTriggerPolicyFluent's github is not equal to the given one.
   */
  public S hasGithub(WebHookTrigger github) {
    // check that actual BuildTriggerPolicyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected github of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    WebHookTrigger actualGithub = actual.getGithub();
    if (!Objects.areEqual(actualGithub, github)) {
      failWithMessage(assertjErrorMessage, actual, github, actualGithub);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildTriggerPolicyFluent's imageChange is equal to the given one.
   * @param imageChange the given imageChange to compare the actual BuildTriggerPolicyFluent's imageChange to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildTriggerPolicyFluent's imageChange is not equal to the given one.
   */
  public S hasImageChange(ImageChangeTrigger imageChange) {
    // check that actual BuildTriggerPolicyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageChange of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ImageChangeTrigger actualImageChange = actual.getImageChange();
    if (!Objects.areEqual(actualImageChange, imageChange)) {
      failWithMessage(assertjErrorMessage, actual, imageChange, actualImageChange);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildTriggerPolicyFluent's type is equal to the given one.
   * @param type the given type to compare the actual BuildTriggerPolicyFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildTriggerPolicyFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual BuildTriggerPolicyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
