package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedTagReferenceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedTagReferenceFluentAssert<S extends AbstractNamedTagReferenceFluentAssert<S, A>, A extends NamedTagReferenceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedTagReferenceFluentAssert}</code> to make assertions on actual NamedTagReferenceFluent.
   * @param actual the NamedTagReferenceFluent we want to make assertions on.
   */
  protected AbstractNamedTagReferenceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedTagReferenceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedTagReferenceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagReferenceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedTagReferenceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagReferenceFluent's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual NamedTagReferenceFluent's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagReferenceFluent's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual NamedTagReferenceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagReferenceFluent's from is equal to the given one.
   * @param from the given from to compare the actual NamedTagReferenceFluent's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagReferenceFluent's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual NamedTagReferenceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagReferenceFluent's name is equal to the given one.
   * @param name the given name to compare the actual NamedTagReferenceFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagReferenceFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedTagReferenceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
