package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentCause} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentCauseAssert<S extends AbstractDeploymentCauseAssert<S, A>, A extends DeploymentCause> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentCauseAssert}</code> to make assertions on actual DeploymentCause.
   * @param actual the DeploymentCause we want to make assertions on.
   */
  protected AbstractDeploymentCauseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentCause's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentCause's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCause's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentCause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentCause's imageTrigger is equal to the given one.
   * @param imageTrigger the given imageTrigger to compare the actual DeploymentCause's imageTrigger to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCause's imageTrigger is not equal to the given one.
   */
  public S hasImageTrigger(DeploymentCauseImageTrigger imageTrigger) {
    // check that actual DeploymentCause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageTrigger of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentCauseImageTrigger actualImageTrigger = actual.getImageTrigger();
    if (!Objects.areEqual(actualImageTrigger, imageTrigger)) {
      failWithMessage(assertjErrorMessage, actual, imageTrigger, actualImageTrigger);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentCause's type is equal to the given one.
   * @param type the given type to compare the actual DeploymentCause's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCause's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual DeploymentCause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
